/* Ukrainian (UTF-8) initialisation for the jQuery UI date picker plugin. */
/* Written by Maxim Drogobitskiy (maxdao@gmail.com). */
/* Corrected by Igor Milla (igor.fsp.milla@gmail.com). */
( function( factory ) {
	// eslint-disable-next-line no-undef
	if ( typeof define === "function" && define.amd ) {
		// AMD. Register as an anonymous module.
		// eslint-disable-next-line no-undef
		define( [ "../widgets/datepicker" ], factory );
	} else {
		// Browser globals
		// eslint-disable-next-line no-undef
		factory( jQuery.datepicker );
	}
}( function( datepicker ) {

datepicker.regional.uk = {
	closeText: "Закрити",
	prevText: "&#x3C;",
	nextText: "&#x3E;",
	currentText: "Сьогодні",
	monthNames: [ "Січень","Лютий","Березень","Квітень","Травень","Червень",
	"Липень","Серпень","Вересень","Жовтень","Листопад","Грудень" ],
	monthNamesShort: [ "Січ","Лют","Бер","Кві","Тра","Чер",
	"Лип","Сер","Вер","Жов","Лис","Гру" ],
	dayNames: [ "неділя","понеділок","вівторок","середа","четвер","п’ятниця","субота" ],
	dayNamesShort: [ "нед","пнд","вів","срд","чтв","птн","сбт" ],
	dayNamesMin: [ "Нд","Пн","Вт","Ср","Чт","Пт","Сб" ],
	weekHeader: "Тиж",
	dateFormat: "dd.mm.yy",
	firstDay: 1,
	isRTL: false,
	showMonthAfterYear: false,
	yearSuffix: "" };
datepicker.setDefaults( datepicker.regional.uk );

return datepicker.regional.uk;

} ) );
